'use client';

import { motion } from 'framer-motion';
import Image from 'next/image';
import Link from 'next/link';

interface FeaturedBlogProps {
    title: string;
    excerpt: string;
    image: string;
    slug: string;
}

export default function FeaturedBlog({ title, excerpt, image, slug }: FeaturedBlogProps) {
    return (
        <section className="w-full mb-16 mt-28">
            <motion.div
                initial={{ opacity: 0, y: 20 }}
                animate={{ opacity: 1, y: 0 }}
                className="relative w-full h-[500px] rounded-xl overflow-hidden"
            >
                <Link href={`/blog/${slug}`}>
                    <div className="relative w-full h-full group">
                        <Image
                            src={image}
                            alt={title}
                            fill
                            className="object-cover transition-transform duration-300 group-hover:scale-105"
                            priority
                        />
                        <div className="absolute inset-0 bg-gradient-to-b from-transparent to-black/60" />
                        <div className="absolute bottom-0 left-0 p-8 text-white">
                            <motion.h1
                                initial={{ opacity: 0, y: 20 }}
                                animate={{ opacity: 1, y: 0 }}
                                transition={{ delay: 0.2 }}
                                className="text-4xl font-script mb-2"
                            >
                                {title}
                            </motion.h1>
                            <motion.p
                                initial={{ opacity: 0, y: 20 }}
                                animate={{ opacity: 1, y: 0 }}
                                transition={{ delay: 0.3 }}
                                className="text-lg font-light max-w-2xl"
                            >
                                {excerpt}
                            </motion.p>
                        </div>
                    </div>
                </Link>
            </motion.div>
        </section>
    );
} 