'use client';

import { motion } from 'framer-motion';
import Image from 'next/image';
import Link from 'next/link';

export interface BlogPostProps {
    slug: string;
    title: string;
    excerpt: string;
    image: string;
    author: string;
    authorImage: string;
    date: string;
}

export default function BlogPost({ title, excerpt, image, author, authorImage, date, slug }: BlogPostProps) {
    return (
        <Link href={`/blog/${slug}`}>
            <motion.div
                initial={{ opacity: 0, y: 20 }}
                whileInView={{ opacity: 1, y: 0 }}
                transition={{ duration: 0.5 }}
                className="flex flex-col gap-4"
            >
                <div className="relative aspect-[4/3] rounded-2xl overflow-hidden">
                    <Image
                        src={image}
                        alt={title}
                        fill
                        className="object-cover hover:scale-105 transition-transform duration-300"
                    />
                </div>
                <div className="space-y-2">
                    <h3 className="text-xl font-medium">{title}</h3>
                    <p className="text-gray-600 line-clamp-2">{excerpt}</p>
                    <div className="flex items-center gap-2 text-sm text-gray-500">
                        <Image src={authorImage} alt={`${author} avatar`} width={40} height={40} className="rounded-full object-cover aspect-square" />
                        <span>{author}</span>
                        <span>•</span>
                        <span>{date}</span>
                    </div>
                </div>
            </motion.div>
        </Link>
    );
} 