import type { Config } from "tailwindcss";

const config: Config = {
  content: [
    "./src/pages/**/*.{js,ts,jsx,tsx,mdx}",
    "./src/components/**/*.{js,ts,jsx,tsx,mdx}",
    "./src/app/**/*.{js,ts,jsx,tsx,mdx}",
  ],
  theme: {
    extend: {
      fontFamily: {
        sans: ["var(--font-lato)"],
        script: ["Belinda Avenue", "cursive"],
      },
      backgroundImage: {
        "gradient-radial": "radial-gradient(var(--tw-gradient-stops))",
        "gradient-conic":
          "conic-gradient(from 180deg at 50% 50%, var(--tw-gradient-stops))",
      },
      fontSize: {
        body: [
          "1rem",
          {
            lineHeight: "160%",
            letterSpacing: "0px",
            fontWeight: "300",
          },
        ],
        "body-lg": [
          "1.1rem",
          {
            lineHeight: "160%",
            letterSpacing: "0px",
            fontWeight: "300",
          },
        ],
        "body-xl": [
          "1.8rem",
          {
            lineHeight: "160%",
            letterSpacing: "0px",
            fontWeight: "300",
          },
        ],
      },
      colors: {
        body: "#222222",
        coral: "#FF7F50",
        mint: "#98FF98",
      },
      letterSpacing: {
        block: "0.15em",
      },
    },
  },
  plugins: [],
};
export default config;
