'use client';

import { motion } from 'framer-motion';
import Image from 'next/image';

interface PartyMember {
    name: string;
    image: string;
}

const troopers: PartyMember[] = [
    { name: "Immanuel Imogie", image: "/party/imogie.jpg" },
    { name: "Dare Ola-Samuel", image: "/party/dare.jpg" },
    { name: "Sam Okolie", image: "/party/sam.png" },
    { name: "Seun Ogungbe", image: "/party/seun.jpg" },
    { name: "Fred Akinmuyisitan", image: "/party/fred.jpg" },
    { name: "Seyi Edema", image: "/party/seyi.jpg" },
];

const darlings: PartyMember[] = [
    { name: "Maureen Odidison", image: "/party/maureen.jpg" },
    { name: "Moji Coker", image: "/party/moji.jpg" },
    { name: "Imisi Owolabi", image: "/party/imisi.jpg" },
    { name: "Toke Falomo", image: "/party/toke.jpg" },
    { name: "Adesuwa Ahanor", image: "/party/adesuwa.jpg" },
    { name: "Victoria Green", image: "/party/victoria.jpg" },
];

const containerVariants = {
    hidden: { opacity: 0 },
    visible: {
        opacity: 1,
        transition: {
            staggerChildren: 0.1
        }
    }
};

const itemVariants = {
    hidden: { opacity: 0, y: 20 },
    visible: {
        opacity: 1,
        y: 0,
        transition: {
            duration: 0.5
        }
    }
};

export default function WeddingParty() {
    return (
        <div className="max-w-7xl mx-auto px-4 py-20">
            <div className="grid grid-cols-1 md:grid-cols-[1fr_2px_1fr] gap-20">
                {/* The Troopers Section */}
                <div>
                    <motion.h2
                        initial={{ opacity: 0 }}
                        whileInView={{ opacity: 1 }}
                        className=" text-4xl md:text-5xl font-script text-coral text-center mb-12"
                    >
                        The Troopers
                    </motion.h2>
                    <motion.div
                        variants={containerVariants}
                        initial="hidden"
                        whileInView="visible"
                        viewport={{ once: true }}
                        className="flex flex-wrap gap-16 justify-center"
                    >
                        {troopers.map((member) => (
                            <motion.div
                                key={member.name}
                                variants={itemVariants}
                                className="flex flex-col items-center"
                            >
                                <div className="w-40 h-40 rounded-full overflow-hidden mb-4 bg-gray-100">
                                    <Image
                                        src={member.image}
                                        alt={member.name}
                                        width={160}
                                        height={160}
                                        className="object-cover w-full h-full"
                                    />
                                </div>
                                <p className="text-[1.25rem]">{member.name}</p>
                            </motion.div>
                        ))}
                    </motion.div>
                </div>

                <div className="md:hidden border-b border-[#454545]/40 py-6 w-2/3 mx-auto self-center"></div>
                <div className="hidden md:block border-l border-[#454545]/40 h-2/3 w-2/3 mx-auto self-center"></div>

                {/* The Darlings Section */}
                <div>
                    <motion.h2
                        initial={{ opacity: 0 }}
                        whileInView={{ opacity: 1 }}
                        className="text-4xl md:text-5xl font-script text-coral text-center mb-12"
                    >
                        The Darlings
                    </motion.h2>
                    <motion.div
                        variants={containerVariants}
                        initial="hidden"
                        whileInView="visible"
                        viewport={{ once: true }}
                        className="flex flex-wrap gap-16 justify-center"
                    >
                        {darlings.map((member) => (
                            <motion.div
                                key={member.name}
                                variants={itemVariants}
                                className="flex flex-col items-center"
                            >
                                <div className="w-40 h-40 rounded-full overflow-hidden mb-4 bg-gray-100">
                                    <Image
                                        src={member.image}
                                        alt={member.name}
                                        width={160}
                                        height={160}
                                        className="object-cover w-full h-full"
                                    />
                                </div>
                                <p className="text-[1.25rem]">{member.name}</p>
                            </motion.div>
                        ))}
                    </motion.div>
                </div>
            </div>
        </div>
    );
} 