'use client';

import { motion } from 'framer-motion';

export default function SubscribeSection() {
    return (
        <section className="py-16 px-4 md:px-8 bg-[#f0f0f0] mt-auto">
            <div className="max-w-md mx-auto text-center">
                <motion.h2
                    initial={{ opacity: 0, y: 20 }}
                    whileInView={{ opacity: 1, y: 0 }}
                    className="text-4xl font-script text-coral mb-4"
                >
                    Subscribe to our Blog
                </motion.h2>
                {/* <p className="text-lg text-[#222222] mb-6">
                    Ut eu porttitor odio suscipit congue. Aliquam placerat massa.
                </p> */}
                <form className="space-y-4">
                    <input
                        type="email"
                        placeholder="Enter your email here"
                        className="w-full px-4 py-2 border-b border-gray-300 bg-transparent focus:outline-none focus:border-coral"
                    />
                    <button
                        type="submit"
                        className="w-full px-8 py-2 btn-solid"
                    >
                        SUBSCRIBE
                    </button>
                </form>
            </div>
        </section>
    );
} 