'use client';

import Image from "next/image";
import { useState, useEffect } from "react";
import AnimatedHero from "./AnimatedHero";
import AnimatedText from './AnimatedText';

const slides = [
  {
    image: "/slider/1.jpg",
    alt: "Save the date: Adaeze and Bolaji",
    component: <AnimatedHero />
  },
  {
    image: "/slider/2.jpg",
    alt: "It's our Leap of Faith to Forever",
    component: <AnimatedText text="It's our Leap of Faith to Forever" />
  },
  {
    image: "/slider/3.jpg",
    alt: "You're my perfect timing!",
    component: <AnimatedText text="You're my perfect timing!" />
  },
  {
    image: "/slider/4.jpg",
    alt: "Let's do this babe",
    component: <AnimatedText text="Let's do this babe" />
  },

];

export default function HeroSlider() {
  const [currentSlide, setCurrentSlide] = useState(0);

  useEffect(() => {
    let mounted = true;

    const timer = setInterval(() => {
      if (mounted) {
        setCurrentSlide((prev) => (prev + 1) % slides.length);
      }
    }, 5000);

    return () => {
      mounted = false;
      clearInterval(timer);
    };
  }, [slides.length]);

  return (
    <div className="relative h-screen w-full overflow-hidden">
      {slides.map((slide, index) => (
        <div key={`slider-${index}`}>
          <div
            className={`absolute inset-0 transition-opacity duration-1000 ease-in-out ${index === currentSlide ? "opacity-100" : "opacity-0"
              }`}
          >
            <Image
              src={slide.image}
              alt={slide.alt}
              fill
              className="object-cover brightness-75"
              priority={index === 0}
            />
          </div>
        </div>
      ))
      }
      <div className="px-2 md:px-0">
        {slides[currentSlide].component}
      </div>
    </div >
  );
} 