'use client';

import { motion } from 'framer-motion';
import Image from "next/image";

export default function AnimatedHero() {
    return (
        <div className="absolute inset-0 flex items-end pb-[100px] md:pb-[120px] justify-center">
            <div className="relative z-10 text-center text-white">
                <motion.div
                    initial={{ opacity: 0, y: 20 }}
                    animate={{ opacity: 1, y: 0 }}
                    transition={{ duration: 1 }}
                    className="mb-1"
                >
                    <div className="relative flex justify-center">
                        <Image
                            src="/ADAEZE-N-BOLAJI.svg"
                            alt="Love is ABC Logo"
                            width={200}
                            height={0}
                            className="w-[300px] md:w-[440px] xl:w-[640px] h-auto"
                        />
                    </div>
                </motion.div>

                <motion.div
                    initial={{ opacity: 0 }}
                    animate={{ opacity: 1 }}
                    transition={{ delay: 0.5, duration: 1 }}
                    className="space-y-3 xl:space-y-4 2xl:space-y-8"
                >
                    <h2 className="tracking-wide block-letters-white xl:text-2xl 2xl:text-3xl text-white font-normal">SAVE THE DATE</h2>
                    <div className="flex justify-center items-center space-x-2 sm:space-x-4 md:space-x-8 xl:text-2xl 2xl:text-3xl font-light">
                        <div>
                            <p>Lekki</p>
                            <p className="">Lagos</p>
                        </div>
                        <div className="border-l border-white h-6"></div>
                        <div>
                            <p>April 25</p>
                            <p className="">2025</p>
                        </div>
                        <div className="border-l border-white h-6"></div>
                        <div>
                            <p>Joining</p>
                            <p className="">12 Noon</p>
                        </div>
                        <div className="border-l border-white h-6"></div>
                        <div>
                            <p>Reception</p>
                            <p className="">3pm</p>
                        </div>
                    </div>

                    <button className="btn-outline-white xl:text-xl 2xl:text-2xl" onClick={() => window.location.href = '#rsvp'}>
                        RSVP
                    </button>
                </motion.div>
            </div>
        </div>
    );
} 