import { NextResponse } from "next/server";

export async function POST(request: Request) {
  try {
    const { email, amount, name } = await request.json();

    const response = await fetch(
      "https://api.paystack.co/transaction/initialize",
      {
        method: "POST",
        headers: {
          Authorization: `Bearer ${process.env.PAYSTACK_SECRET_KEY}`,
          "Content-Type": "application/json",
        },
        body: JSON.stringify({
          email,
          amount: amount * 100, // Convert to kobo
          callback_url: `${process.env.BASE_URL}/success`,
          metadata: {
            name,
          },
        }),
      }
    );

    const data = await response.json();

    if (!data.status) {
      throw new Error(data.message);
    }

    return NextResponse.json(data);
  } catch (error) {
    console.error("Paystack initialization error:", error);
    return NextResponse.json(
      { error: "Failed to initialize payment" },
      { status: 500 }
    );
  }
}
